<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manage_state extends CI_Controller {
	
	public function __construct(){
		parent::__construct();

		$this->load->model('admin/mod_admin');
		$this->load->model('areas/mod_areas');
		$this->load->model('common/mod_common');
		
		$this->load->library('BreadcrumbComponent');
		
	}

	public function index(){
	//Login Check
		$this->mod_admin->verify_is_admin_login();
		
		//Verify if Page is Accessable
		if(!in_array(156,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if

		//Plugin Files Permission
		$data['PLUGIN_datagrid'] = 1;
		$data['PLUGIN_datepicker'] = 0;
		$data['PLUGIN_gcal'] = 0;
		$data['PLUGIN_form_validation'] = 0;
		$data['PLUGIN_gallery'] = 0;
		$data['PLUGIN_ckeditor'] = 0;
		$data['PLUGIN_floatchart'] = 0;

		//Common Includes
		$data['meta_title'] = DEFAULT_TITLE;
		$data['meta_keywords'] = DEFAULT_META_KEYWORDS;
		$data['meta_description'] = DEFAULT_META_DESCRIPTION;

		$fetch_nav_panel = $this->mod_common->fetch_admin_nav_panel();
		$data['nav_panel_arr'] = $fetch_nav_panel;

		//Bread crum
		$this->breadcrumbcomponent->add('Dashboard', base_url().'dashboard/dashboard');
		$this->breadcrumbcomponent->add('Manage State', base_url().'areas/manage-state');
		$data['breadcrum_data'] = $this->breadcrumbcomponent->output();
		
		$data['INC_header_script_top'] = $this->load->view('common/script_header',$data,true);
		$data['INC_header_script_footer'] = $this->load->view('common/script_footer',$data,true);
		$data['INC_top_header'] = $this->load->view('common/top_header','',true);
		$data['INC_left_nav_panel'] = $this->load->view('common/left_nav_panel',$data,true);
		$data['INC_footer'] = $this->load->view('common/footer','',true);
		$data['INC_breadcrum'] = $this->load->view('common/breadcrum',$data,true);
		 
		//Permissions
		$data['ALLOW_pages_add'] =   (in_array(156,$this->session->userdata('permissions_arr'))) ? 1 : 0;
		$data['ALLOW_pages_edit'] =   (in_array(156,$this->session->userdata('permissions_arr'))) ? 1 : 0;
		$data['ALLOW_pages_delete'] =   (in_array(156,$this->session->userdata('permissions_arr'))) ? 1 : 0;
         $get_state = $this->mod_areas->get_all_state();

		$data['state_arr'] = $get_state['state_arr'];
		$data['state_count'] = $get_state['state_row_count'];
		
		$this->load->view('areas/manage_state',$data);
		
	}
	       
	public function process_state_grid(){
            
		echo $this->mod_areas->get_filter_state_grid_data();
		
	}

  	public function add_state(){
      
		//Login Check
		$this->mod_admin->verify_is_admin_login();
		//Verify if Page is Accessable
		if(!in_array(156,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
		//Plugin Files Permission
		$data['PLUGIN_datagrid'] = 0;
		$data['PLUGIN_datepicker'] = 0;
		$data['PLUGIN_gcal'] = 0;
		$data['PLUGIN_form_validation'] = 1;
		$data['PLUGIN_gallery'] = 0;
		$data['PLUGIN_ckeditor'] = 1;
		$data['PLUGIN_floatchart'] = 0;
		
		//Common Includes
		$data['meta_title'] = DEFAULT_TITLE;
		$data['meta_keywords'] = DEFAULT_META_KEYWORDS;
		$data['meta_description'] = DEFAULT_META_DESCRIPTION;
		
		$fetch_nav_panel = $this->mod_common->fetch_admin_nav_panel();
		$data['nav_panel_arr'] = $fetch_nav_panel;
		
		//Bread crum
		$this->breadcrumbcomponent->add('Dashboard', base_url().'dashboard/dashboard');
		$this->breadcrumbcomponent->add('Manage Areas', base_url().'areas/manage-areas/');
		$this->breadcrumbcomponent->add('Add New State', base_url().'areas/manage-areas/add-state');
		$data['breadcrum_data'] = $this->breadcrumbcomponent->output();
		
		$data['INC_header_script_top'] = $this->load->view('common/script_header',$data,true);
		$data['INC_header_script_footer'] = $this->load->view('common/script_footer',$data,true);
		$data['INC_top_header'] = $this->load->view('common/top_header','',true);
		$data['INC_left_nav_panel'] = $this->load->view('common/left_nav_panel',$data,true);
		$data['INC_footer'] = $this->load->view('common/footer','',true);
		$data['INC_breadcrum'] = $this->load->view('common/breadcrum','',true);

		//Fetching Table Listing
	   $get_countries = $this->mod_areas->get_all_countries();

		$data['countries_arr'] = $get_countries['countries_arr'];
		
		$this->load->view('areas/add_state',$data);
		
	}//add_state
        
	public function add_new_state_process(){
//            echo SURL."services/manage-services/add-new-service.'<br />'";
            
		//If Post is not SET
		if(!$this->input->post() && !$this->input->post('add_new_state_sbt')) 
		redirect(base_url().'areas/manage-areas/add-state');
		
		//Login Check
		$this->mod_admin->verify_is_admin_login();

		//Verify if Page is Accessable
		if(!in_array(156,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
            
	if(trim($this->input->post('country')) == ''){
                    
			$this->session->set_flashdata('err_message', '- country Name field is empty.');
			redirect(base_url().'areas/manage-areas/add-state');
			
		}//end if(trim($this->input->post('service_name')) == '')

		if(trim($this->input->post('state_name')) == ''){
                    
			$this->session->set_flashdata('err_message', '- State Name field is empty.');
			redirect(base_url().'areas/manage-areas/add-state');
			
		}//end if(trim($this->input->post('service_name')) == '')
		elseif(trim($this->input->post('status')) == ''){
                    
			$this->session->set_flashdata('err_message', '- Status Type field is empty.');
			redirect(base_url().'areas/manage-areas/add-state');
			
		}//end elseif(trim($this->input->post('status')) == '')

                else{
//                    echo 'else....'; exit();
			$add_new_state = $this->mod_areas->add_new_state($this->input->post());

			if($add_new_state){
				
				//Unset POST values from session
				
				
				$this->session->set_flashdata('ok_message', '- New State has been added successfully.');
				redirect(base_url().'areas/manage-areas/add-state');
				
			}else{
				$this->session->set_flashdata('err_message', '- New State is not added. Something went wrong, please try again.');
				redirect(base_url().'areas/manage-areas/add-state');
				
			}//end if($add_new_service)
			
		}//end 

	}//end add_new_state_process   
        

	    

	public function edit_state($state_id){
		//Login Check
		$this->mod_admin->verify_is_admin_login();
		
		//Verify if Page is Accessable
		if(!in_array(156,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		//Plugin Files Permission
		$data['PLUGIN_datagrid'] = 0;
		$data['PLUGIN_datepicker'] = 0;
		$data['PLUGIN_gcal'] = 0;
		$data['PLUGIN_form_validation'] = 1;
		$data['PLUGIN_gallery'] = 0;
		$data['PLUGIN_ckeditor'] = 1;
		$data['PLUGIN_floatchart'] = 0;
		
		//Common Includes
		$data['meta_title'] = DEFAULT_TITLE;
		$data['meta_keywords'] = DEFAULT_META_KEYWORDS;
		$data['meta_description'] = DEFAULT_META_DESCRIPTION;
		
		$fetch_nav_panel = $this->mod_common->fetch_admin_nav_panel();
		$data['nav_panel_arr'] = $fetch_nav_panel;
		
		//Bread crum
		$this->breadcrumbcomponent->add('Dashboard', base_url().'dashboard/dashboard');
		$this->breadcrumbcomponent->add('Manage State', base_url().'areas/manage-state');
		$this->breadcrumbcomponent->add('Edit State', base_url().'areas/manage-state/edit-state/'.$state_id);
		$data['breadcrum_data'] = $this->breadcrumbcomponent->output();
		
		$data['INC_header_script_top'] = $this->load->view('common/script_header',$data,true);
		$data['INC_header_script_footer'] = $this->load->view('common/script_footer',$data,true);
		$data['INC_top_header'] = $this->load->view('common/top_header','',true);
		$data['INC_left_nav_panel'] = $this->load->view('common/left_nav_panel',$data,true);
		$data['INC_footer'] = $this->load->view('common/footer','',true);
		$data['INC_breadcrum'] = $this->load->view('common/breadcrum','',true);
		
		
		 $get_countries = $this->mod_areas->get_all_countries();

		$data['countries_arr'] = $get_countries['countries_arr'];
		
		//Fetching Table Listing
		       $get_state_data = $this->mod_areas->get_state_row($state_id);
                $data['state_row_arr'] = $get_state_data['state_row_arr'];
                $data['state_row_count'] = $get_state_data['state_row_count'];
                
//            exit($get_services_data['services_row_count']);
        if($get_state_data['state_row_count'] == 0 ) redirect (base_url() . 'errors/page-not-found-404');
                
		$this->load->view('areas/edit_state',$data);
		
	}


	public function edit_state_process(){

		//If Post is not SET
		if(!$this->input->post() && !$this->input->post('edit_sbt')) redirect(base_url());
		
		//Login Check
		$this->mod_admin->verify_is_admin_login();

		
		//Verify if Page is Accessable
		if(!in_array(156,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
		$stateid = $this->input->post('stateid');

		$err_msg = '';
		if(trim($this->input->post('country')) == ''){
			
			$err_msg.= '- Country Name field cannot be empty.<br>';
			
		}//end if(trim($this->input->post('page_title')) == '')
		elseif(trim($this->input->post('state_name')) == ''){
			
			$err_msg.= '- State Name field cannot be empty.<br>';
			
		}//end if(trim($this->input->post('page_title')) == '')
		elseif(trim($this->input->post('status')) == ''){
			
			$err_msg.= '- state Type field cannot be empty.<br>';
			
		}
		if($err_msg != ''){

			$this->session->set_flashdata('err_message', $err_msg);
			redirect(base_url().'areas/manage-state/edit-state/'.$stateid);
			
		}//end if($err_msg !='')

		//Updating Table Data
		$upd_state = $this->mod_areas->edit_state($this->input->post());
		
                if($upd_state){

                        $this->session->set_flashdata('ok_message', '- State Record has been updated successfully.');
//                        redirect(base_url().'services/manage-services/edit-service/'.$service_id);
                        redirect(base_url().'areas/manage-state');

                }else{
                        $this->session->set_flashdata('err_message', '- State Record has NOT been updated. Something went wrong, please try again.');
                        redirect(base_url().'areas/manage-state/edit-state/'.$stateid);

                }//end if($upd_service)

	}
        
        

	public function delete_state($state_id){

		//Login Check
		$this->mod_admin->verify_is_admin_login();

		//Verify if Page is Accessable
		if(!in_array(156,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
		$del_state= $this->mod_areas->delete_state($state_id);
		
		if($del_state){
			
			$this->session->set_flashdata('ok_message', '- STATE deleted successfully.');
			redirect(base_url().'areas/manage-state');
			
		}else{
			$this->session->set_flashdata('err_message', '- STATE cannot be deleted. Something went wrong, please try again.');
			redirect(base_url().'areas/manage-state');
			
		}//end if

	}
}