<?php
class mod_common extends CI_Model {
	function __construct(){
		
        parent::__construct();
    }
	
	//Random Password Generator
	public function random_number_generator($digit){

		$randnumber = '';
		$totalChar = $digit;  //length of random number
		$salt = "0123456789";  // salt to select chars
		srand((double)microtime()*1000000); // start the random generator
		$password=""; // set the inital variable
		
		for ($i=0;$i<$totalChar;$i++)  // loop and create number
		$randnumber = $randnumber. substr ($salt, rand() % strlen($salt), 1);
		
		return $randnumber;
		
	}// random_password_generator()
	
	
	//Random Alhpa Numeric string generator
	public function random_alphanumaric_generator($digit){

		$randnumber = '';
		$totalChar = $digit;  //length of random number
		$salt = "0123456789ABCBEFGHIJKLMNOPQRSTUVWXYZ";  // salt to select chars
		srand((double)microtime()*1000000); // start the random generator
		$password=""; // set the inital variable
		
		for ($i=0;$i<$totalChar;$i++)  // loop and create number
		$randnumber = $randnumber. substr ($salt, rand() % strlen($salt), 1);
		
		return $randnumber;
		
	}// random_password_generator()

	//Generating URL string, eliminating special characters.
	
	//Random Ticket Number Generator
	public function random_ticket_number($digit){

		$randnumber = '';
		$totalChar = $digit;  //length of random number
		$salt = "0123456789";  // salt to select chars
		srand((double)microtime()*1000000); // start the random generator
		$password=""; // set the inital variable
		
		for ($i=0;$i<$totalChar;$i++)  // loop and create number
		$randnumber = $randnumber. substr ($salt, rand() % strlen($salt), 1);
		
		return '##'.$randnumber.'##' ;
		
	}// random_password_generator()

	//Generating URL string, eliminating special characters.
	//getting specific data on base of where
	function get_data_by_where($table,$fields = false,$where){
		
		if(!$fields){
			$fields = '*';
		}
		$this->db->select($fields);
        $this->db->from($table);
        $this->db->where($where);
        $query = $this->db->get();
        return $query->result();
	
	}
	
	public function generate_seo_url($url_string){
		
		$str_tmp = str_replace(' ', '-', $url_string); // Replaces all spaces with hyphens.
		return strtolower(preg_replace('/[^A-Za-z0-9\-]/', '', $str_tmp)); 	// Replaces all Special characters	
		
	}//end generate_seo_url
	
	//If URL String already exist in the database table record generate new.
	public function verify_seo_url($url_string,$table_name,$field_name,$exclude_self){

			$this->db->dbprefix($table_name);
			$this->db->select('id');
			$this->db->where($field_name, $url_string); 
			if($exclude_self != 0) $this->db->where('id !=', $exclude_self); 
			$rs_count_rec = $this->db->get($table_name);
			//echo $this->db->last_query(); exit;
			
			if($rs_count_rec->num_rows == 0) return $url_string;
			else{
				//Add Postfix and generate concatenate.
				$generate_postfix = $this->mod_common->random_number_generator(3);
				$new_url_string = $url_string.'-'.$generate_postfix;
				return $this->mod_common->verify_seo_url($new_url_string,$table_name,'seo_url_name',$exclude_self);
				
			}//end if
		
	}//end verify_seo_url
	
	//Convert mysql format date to user defined date
	public function user_define_date($sqldate){
		
		if($sqldate!='') return date("M j, Y", strtotime($sqldate));
		else return '';
		
	}//end user_define_ddate()


	//Convert mm/dd/yyyy to Mysql Date forma Y-m-d
	public function convert_to_mysql_date($user_date){
		
		if($user_date!='') return date("Y-m-d", strtotime($user_date));
		else return '';	//end if($user_date!='')
		
	}//end convert_mysql_date()

	//Convert Mysql Date format Y-m-d to mm/dd/yyyy
	public function convert_to_standard_date($mysqldate){
		
		if($mysqldate!=''){
			return date("m/d/Y", strtotime($mysqldate));
		}else{
			return '';	
		}//end if($user_date!='')
		
	}//end convert_mysql_date()

	//Split the date and get the Array of Month, Day and Year. Allowed Date format Y-m-d and mm/dd/yyyy
	public function convert_date_to_array($mysqldate, $date_format){
		
		$date_split = array();
		
		if($mysqldate!=''){
			
			if($date_format == 'Y-m-d'){

				$dated = explode('-', $mysqldate);
				$date_split['year']  = $dated[0];
				$date_split['month'] = $dated[1];
				$date_split['day'] = $dated[2];
				
			}else{
				
				$dated = explode('/', $mysqldate);
				$date_split['year']  = $dated[2];
				$date_split['month'] = $dated[0];
				$date_split['day'] = $dated[1];
				
			}//end if($date_format == 'Y-m-d')
			
		}//end if($mysqldate!='')
		
		return $date_split;
		
	}//end convert_mysql_date()
	
	
	//A generic Function Used When a single value need to be accessed from the database. 
	public function db_common_function($select_field, $tablename, $where_fieldname, $where_fieldvalue){
		
		$this->db->select($select_field);
		$this->db->where($where_fieldname, $where_fieldvalue); 
		$get_if_record_exist = $this->db->get($tablename);
		$row_get_if_record_exist = $get_if_record_exist->row();
		
		if($get_if_record_exist->num_rows > 0) return $row_get_if_record_exist->$select_field;
		else return;
		
		
	}//end db_common_function

	//To get the number of days of a month in a given year. Parameter Given is a MYSQL date format
	function calculate_no_of_month_days($date){
		
		$year 	= date('Y', strtotime($date));
		$mmonth	= date('m', strtotime($date));
		$no_of_days  = cal_days_in_month(CAL_GREGORIAN,$month,$year);
		return $no_of_days ;
		
	}//end calculate_no_of_month_days
	


	##################################################
	#
	#  	A function that would delete folders, subfolders and files
	#
	##################################################
	
	public function remove_directory( $dir, $DeleteMe = TRUE ){
	
		if ( ! $dh = @opendir ( $dir ) ) return;
		
		while ( false !== ( $obj = readdir ( $dh ) ) ){
			if ( $obj == '.' || $obj == '..') continue;

			if ( ! @unlink ( $dir . '/' . $obj ) ) 
				$this->mod_common->remove_directory ( $dir . '/' . $obj, true );
			
		}
		
		closedir ( $dh );
		if ( $DeleteMe ){
			@rmdir ( $dir );
		}
	}//end remove_directory
	
	//Fetch Left Navigation Panel
	function fetch_admin_nav_panel(){

		$this->db->dbprefix('admin_user_roles');
		$this->db->where('show_in_nav',1);
		$this->db->order_by('display_order', 'DESC');
		
		$get_admin_navpanel = $this->db->get('admin_menu');

		//echo $this->db->last_query(); exit;
		$admin_nav_panel_arr = $get_admin_navpanel->result_array();
		
		for($i = 0 ;$i<count($admin_nav_panel_arr);$i++){
			
			if($admin_nav_panel_arr[$i]['parent_id'] == 0){
				
				$nav_panel_arr[$admin_nav_panel_arr[$i]['id']]['menu_id'] = $admin_nav_panel_arr[$i]['id'];
				$nav_panel_arr[$admin_nav_panel_arr[$i]['id']]['menu_title'] = $admin_nav_panel_arr[$i]['menu_title'];
				$nav_panel_arr[$admin_nav_panel_arr[$i]['id']]['menu_icon_class'] = $admin_nav_panel_arr[$i]['icon_class_name'];
				$nav_panel_arr[$admin_nav_panel_arr[$i]['id']]['show_in_nav'] = $admin_nav_panel_arr[$i]['show_in_nav'];
				$nav_panel_arr[$admin_nav_panel_arr[$i]['id']]['url_link'] = $admin_nav_panel_arr[$i]['url_link'];
				$nav_panel_arr[$admin_nav_panel_arr[$i]['id']]['status'] = $admin_nav_panel_arr[$i]['status'];
				
			}else{
				
				$nav_panel_arr[$admin_nav_panel_arr[$i]['parent_id']]['sub_menu'][] = $admin_nav_panel_arr[$i];
				
			}//end if
			
		}//end for

/*		echo '<pre>';
		print_r($nav_panel_arr);
		exit;
*/		
		return array_reverse($nav_panel_arr);
		
	}//end fetch_admin_nav_panel

	//Get List of all Menues
	function get_admin_menu_list(){

		$this->db->dbprefix('admin_user_roles');
		$this->db->select('id,menu_title,parent_id,set_as_default,status');
		$this->db->where('status',1);
		
		$get_admin_navpanel = $this->db->get('admin_menu');

		//echo $this->db->last_query();
		$admin_nav_panel_arr = $get_admin_navpanel->result_array();
		
		for($i = 0 ;$i<count($admin_nav_panel_arr);$i++){
			
			if($admin_nav_panel_arr[$i]['parent_id'] == 0){
				
				$nav_panel_arr[$admin_nav_panel_arr[$i]['id']]['menu_title'] = $admin_nav_panel_arr[$i]['menu_title'];
				$nav_panel_arr[$admin_nav_panel_arr[$i]['id']]['status'] = $admin_nav_panel_arr[$i]['status'];
				$nav_panel_arr[$admin_nav_panel_arr[$i]['id']]['set_as_default'] = $admin_nav_panel_arr[$i]['set_as_default'];
				
			}else{
				
				$nav_panel_arr[$admin_nav_panel_arr[$i]['parent_id']]['sub_menu'][] = $admin_nav_panel_arr[$i];
				
			}//end if
			
		}//end for

		return $nav_panel_arr;
		
	}//end get_admin_menu_list
	
	
	

	//Get cms page
	public function get_cms_page($seo_url_name){
		
		$this->db->dbprefix('pages');
		$this->db->where('seo_url_name',$seo_url_name);
		$get_page = $this->db->get('pages');
		//echo $this->db->last_query(); exit;
		$row_page = $get_page->row_array();
		
		return $row_page;		
		
	}//end get_cms_page		
	
	
	//Get payment
	public function get_payment(){
		
		$this->db->dbprefix('payment_setting');
		$this->db->where('status',1);
		$get_payment_setting = $this->db->get('payment_setting');
		//echo $this->db->last_query(); exit;
		$row_get_payment_setting = $get_payment_setting->row_array();
		
		return $row_get_payment_setting;		
		
	}//end get_cms_page				
				
	
   //Edit payment
    public function edit_payment($data) {

        extract($data);
        $upd_data = array(
		    'admin_mail' => $this->db->escape_str(trim($adminemail)),
            'admin' => $this->db->escape_str(trim($admin)),
		    'serviceprovider' => $this->db->escape_str(trim($service_provider)),
            'status' => $this->db->escape_str(trim($status))
        );


        
        $this->db->dbprefix('payment_setting');
        $this->db->where('id', $id);
        $upd_into_db = $this->db->update('payment_setting', $upd_data);
    

        if ($upd_into_db)
            return true;
    }
	
	
	public function payment_history(){
		
		$this->db->dbprefix('payment_details');
		$this->db->where('status !='," ");
		$get_payment = $this->db->get('payment_details');
		//echo $this->db->last_query(); exit;
		$row_get_payment = $get_payment->result();
		
		return $row_get_payment;		
		
	}//end get_cms_page				
	
    
   public function get_filter_payment_grid_data() {

        /* Array of database columns which should be read and sent back to DataTables. Use a space where
         * you want to insert a non-database field (for example a counter or static image)
         */
//        $aColumns = array('`display_name`','username','admin_role_id','last_signin_date','status','id');
        $aColumns = array('buyer_id', 'job_id', 'seller_payment', 'admin_payment', 'status');

        // DB table to use
        $sTable = 'payment_details';
         
        $this->db->order_by('pay_id DESC');
		$q = $this->db->query("SELECT bpd.*,bu.first_name,bu.last_name,(SELECT job_title FROM bir_jobs WHERE job_id=bpd.job_id) as job_title FROM bir_payment_details bpd, bir_users bu WHERE bpd.buyer_id=bu.id");


        $iDisplayStart = $this->input->get_post('iDisplayStart', true);
        $iDisplayLength = $this->input->get_post('iDisplayLength', true);
        $iSortCol_0 = $this->input->get_post('iSortCol_0', true);
        $iSortingCols = $this->input->get_post('iSortingCols', true);
        $sSearch = $this->input->get_post('sSearch', true);
        $sEcho = $this->input->get_post('sEcho', true);

        // Paging
        if (isset($iDisplayStart) && $iDisplayLength != '-1') {
            $this->db->limit($this->db->escape_str($iDisplayLength), $this->db->escape_str($iDisplayStart));
        }

        // Ordering
        if (isset($iSortCol_0)) {
            for ($i = 0; $i < intval($iSortingCols); $i++) {
                $iSortCol = $this->input->get_post('iSortCol_' . $i, true);
                $bSortable = $this->input->get_post('bSortable_' . intval($iSortCol), true);
                $sSortDir = $this->input->get_post('sSortDir_' . $i, true);

                if ($bSortable == 'true') {
                    $this->db->order_by($aColumns[intval($this->db->escape_str($iSortCol))], $this->db->escape_str($sSortDir));
                }
            }
        }

        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        if (isset($sSearch) && !empty($sSearch)) {
            for ($i = 0; $i < count($aColumns); $i++) {
                $bSearchable = $this->input->get_post('bSearchable_' . $i, true);

                // Individual column filtering
                if (isset($bSearchable) && $bSearchable == 'true') {
                    $this->db->or_like($aColumns[$i], $sSearch);
                }
            }
        }


        // Select Data
        $this->db->select('SQL_CALC_FOUND_ROWS ' . str_replace(' , ', ' ', implode(', ', $aColumns)), false);
        $this->db->dbprefix($sTable);
        $rResult = $this->db->get($sTable);

        // Data set length after filtering
        $this->db->dbprefix($sTable);
        $this->db->select('FOUND_ROWS() AS found_rows');
        $iFilteredTotal = $this->db->get()->row()->found_rows;

        // Total data set length
        $iTotal = $this->db->count_all($sTable);


        // Output
        $output = array(
            'sEcho' => intval($sEcho),
            'iTotalRecords' => $iTotal,
            'iTotalDisplayRecords' => $iFilteredTotal,
            'aaData' => array()
        );
				
	
        foreach ($q->result_array() as $payment) {
				
            $row = array();
            $option_html = '';
					$a=$payment['seller_payment'];
					$b=$payment['admin_payment'];
           
				

                   $row[] = "<strong>" . $payment['first_name']."&nbsp;" .$payment['last_name']. "</strong>";
				    $row[] = "<strong>" . $payment['job_title'] . "</strong>";
					$row[] = "<strong> $" . number_format(round(($a + $b),3)) . "</strong>";
					$row[] = "<strong>" . date("Y-m-d",strtotime($payment['date_created'])). "</strong>";	
					
              
                    $row[] = ($payment['status'] == "paid") ? '<span class="label btn-success">Paid</span>' : '<span class="label btn-danger">Unpaid</span>';

               
                    
             

            $output['aaData'][] = $row;
        
			}

        echo json_encode($output);
    } //end get_filter        
	
	
	
	
	
	
	
	
	
	
	
	
	

}

?>