<?php
class mod_faqs extends CI_Model {
	
	function __construct(){
		
        parent::__construct();
    }
	//Get All Records From bir_faqs Table.
	public function get_faqs_record( $faq_id = false ){
		
		$this->db->dbprefix('faqs');
		$this->db->order_by('id DESC');
		$get_faqs = $this->db->get('faqs');
//		echo $this->db->last_query();exit();

		$row_faqs['faqs_arr'] = $get_faqs->result_array();
		$row_faqs['faqs_count'] = $get_faqs->num_rows;
		return $row_faqs;
		
	}


    //Filter Grid for Manage Faqs
    public function get_filter_faqs_grid_data() {

        /* Array of database columns which should be read and sent back to DataTables. Use a space where
         * you want to insert a non-database field (for example a counter or static image)
         */
//        $aColumns = array('`display_name`','username','admin_role_id','last_signin_date','status','id');
        $aColumns = array('question', 'answer', 'created_date', 'status', 'id');

        // DB table to use
        $sTable = 'faqs';
        $this->db->order_by('id DESC');


        $iDisplayStart = $this->input->get_post('iDisplayStart', true);
        $iDisplayLength = $this->input->get_post('iDisplayLength', true);
        $iSortCol_0 = $this->input->get_post('iSortCol_0', true);
        $iSortingCols = $this->input->get_post('iSortingCols', true);
        $sSearch = $this->input->get_post('sSearch', true);
        $sEcho = $this->input->get_post('sEcho', true);

        // Paging
        if (isset($iDisplayStart) && $iDisplayLength != '-1') {
            $this->db->limit($this->db->escape_str($iDisplayLength), $this->db->escape_str($iDisplayStart));
        }

        // Ordering
        if (isset($iSortCol_0)) {
            for ($i = 0; $i < intval($iSortingCols); $i++) {
                $iSortCol = $this->input->get_post('iSortCol_' . $i, true);
                $bSortable = $this->input->get_post('bSortable_' . intval($iSortCol), true);
                $sSortDir = $this->input->get_post('sSortDir_' . $i, true);

                if ($bSortable == 'true') {
                    $this->db->order_by($aColumns[intval($this->db->escape_str($iSortCol))], $this->db->escape_str($sSortDir));
                }
            }
        }

        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        if (isset($sSearch) && !empty($sSearch)) {
            for ($i = 0; $i < count($aColumns); $i++) {
                $bSearchable = $this->input->get_post('bSearchable_' . $i, true);

                // Individual column filtering
                if (isset($bSearchable) && $bSearchable == 'true') {
                    $this->db->or_like($aColumns[$i], $sSearch);
                }
            }
        }


        // Select Data
        $this->db->select('SQL_CALC_FOUND_ROWS ' . str_replace(' , ', ' ', implode(', ', $aColumns)), false);
        $this->db->dbprefix($sTable);
        $rResult = $this->db->get($sTable);

        // Data set length after filtering
        $this->db->dbprefix($sTable);
        $this->db->select('FOUND_ROWS() AS found_rows');
        $iFilteredTotal = $this->db->get()->row()->found_rows;

        // Total data set length
        $iTotal = $this->db->count_all($sTable);


        // Output
        $output = array(
            'sEcho' => intval($sEcho),
            'iTotalRecords' => $iTotal,
            'iTotalDisplayRecords' => $iFilteredTotal,
            'aaData' => array()
        );
        foreach ($rResult->result_array() as $aRow) {
            $row = array();
            $option_html = '';
            foreach ($aColumns as $col) {

                if ($col == 'question') {
                    $row[] = "<strong>" . $aRow['question'] . "</strong>";
                }
                elseif($col == 'answer'){
                        $row[] = "<strong>" . $aRow['answer'] . "</strong>";
                }
//                elseif($col == 'faq_type'){
//                        $row[] = "<strong>" . $aRow['faq_type'] . "</strong>";
//                }
//                elseif($col == 'faq_type'){
//                        $row[] = "<strong>" . $aRow['faq_type'] . "</strong>";
//                }
//                elseif($col == 'last_signin_date'){
//                        $row[] = date('d, M Y h:i:s a', strtotime(stripslashes($aRow['last_signin_date'])));
//                }
                elseif ($col == 'created_date') {
//                    $row[] = date('d, M Y, h:i:s a', (strtotime($aRow['created_date'])));
                    $row[] = date('d, M Y', (strtotime($aRow['created_date'])));
                } 
                elseif ($col == 'status') {
                    $row[] = ($aRow[$col] == 1) ? '<span class="label btn-success">Active</span>' : '<span class="label btn-danger">InActive</span>';
                } 
                elseif ($col == 'id') {
                    $option_html .= '<div class="btn-group">';

                    if (in_array(146, $this->session->userdata('permissions_arr'))) {
                        $option_html .= "<a href=" . SURL . "faqs/manage-faqs/edit-faq/" . $aRow['id'] . " type='button' class='btn btn-info btn-gradient'> <span class='glyphicons glyphicons-edit'></span> </a>";
                    }//end if

                    if (in_array(147, $this->session->userdata('permissions_arr'))) {
                        $option_html .= "<a href=" . SURL . "faqs/manage-faqs/delete-faq/" . $aRow['id'] . " type='button' class='btn btn-danger btn-gradient' onClick=\"return confirm('Are you sure you want to delete?')\"> <span class='glyphicons glyphicons-remove'></span> </a>";
                    }//end if


                    $option_html .= '</div>';
                    $row[] = $option_html;
                } else
                    $row[] = $aRow[$col];
            }

            $output['aaData'][] = $row;
        }


        echo json_encode($output);
    } //end get_filter_faqs_grid_data        

    
    //Add New Faq
    public function add_new_faq($data) {
        extract($data);

        $created_date = date('Y-m-d G:i:s');
//        $ip_address = $this->input->ip_address();
        $created_by = $this->session->userdata('admin_id_sec_erp');

        $ins_data = array(
            'question' => $this->db->escape_str(trim($question)),
            'answer' => $this->db->escape_str(trim($answer)),
            'status' => $this->db->escape_str(trim($status)),
            'created_by' => $this->db->escape_str(trim($created_by)),
//            'created_by_ip' => $this->db->escape_str(trim($ip_address)),
            'created_date' => $this->db->escape_str(trim($created_date)),
        );

        //Insert the record into the database.
        $this->db->dbprefix('faqs');
        $ins_into_db = $this->db->insert('faqs', $ins_data);

        if ($ins_into_db)
            return true;
    } //end add_new_faq()

    
    //Delete Faqs Record
    public function delete_faq($faq_id) {

        //Delete the record from the database.
        $this->db->dbprefix('faqs');
        $this->db->where('id', $faq_id);
        $del_into_db = $this->db->delete('faqs');
        if ($del_into_db)
            return true;
        //	echo $this->db->last_query();
    } //end delete_faq

    

    
    // get specific record    
    function get_faqs_row($faq_id) {

        $this->db->dbprefix('faqs');
        $this->db->where('id', $faq_id);
        $get_faqs_row = $this->db->get('faqs');
        //        echo $this->db->last_query();

        $faqs_row['faqs_row_arr'] = $get_faqs_row->row_array();
        $faqs_row['faqs_row_count'] = $get_faqs_row->num_rows;

        return $faqs_row;
    }
// end get_faq_seats_row

    //Edit Faq Data
    public function edit_faq($data) {

        extract($data);

        $last_modified_date = date('Y-m-d G:i:s');
        $last_modified_by = $this->session->userdata('faq_id');
//        $last_modified_ip = $this->input->ip_address();


        $upd_data = array(
            'question' => $this->db->escape_str(trim($question)),
            'answer' => $this->db->escape_str(trim($answer)),
            'status' => $this->db->escape_str(trim($status)),
            'last_modified_by' => $this->db->escape_str(trim($last_modified_by)),
            'last_modified_date' => $this->db->escape_str(trim($last_modified_date)),
//            'last_modified_ip' => $this->db->escape_str(trim($last_modified_ip))
        );


        //Updating the record into the database.
        $this->db->dbprefix('faqs');
        $this->db->where('id', $faq_id);
        $upd_into_db = $this->db->update('faqs', $upd_data);
        //echo $this->db->last_query(); exit;

        if ($upd_into_db)
            return true;
    }

//end edit_faq
}
