<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/*
|--------------------------------------------------------------------------
| File and Directory Modes
|--------------------------------------------------------------------------
|
| These prefs are used when checking and setting modes when working
| with the file system.  The defaults are fine on servers with proper
| security, but you may wish (or even need) to change the values in
| certain environments (Apache running a separate process for each
| user, PHP under CGI with Apache suEXEC, etc.).  Octal values should
| always be used to set the mode correctly.
|
*/
define('FILE_READ_MODE', 0644);
define('FILE_WRITE_MODE', 0666);
define('DIR_READ_MODE', 0755);
define('DIR_WRITE_MODE', 0777);

/*
|--------------------------------------------------------------------------
| File Stream Modes
|--------------------------------------------------------------------------
|
| These modes are used when working with fopen()/popen()
|
*/

define('FOPEN_READ',							'rb');
define('FOPEN_READ_WRITE',						'r+b');
define('FOPEN_WRITE_CREATE_DESTRUCTIVE',		'wb'); // truncates existing file data, use with care
define('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE',	'w+b'); // truncates existing file data, use with care
define('FOPEN_WRITE_CREATE',					'ab');
define('FOPEN_READ_WRITE_CREATE',				'a+b');
define('FOPEN_WRITE_CREATE_STRICT',				'xb');
define('FOPEN_READ_WRITE_CREATE_STRICT',		'x+b');

date_default_timezone_set('Asia/Karachi');

define('DEFAULT_TITLE','Welcome to CrunchyLand');
define('DEFAULT_META_KEYWORDS','Default Meta Keywords');
define('DEFAULT_META_DESCRIPTION','default Meta Description');

define('SITE_NAME','CrunchyLand');
define('MURL','http://'.$_SERVER['HTTP_HOST'].'/projects/lhr/crunchyland/');
define('SURL','http://'.$_SERVER['HTTP_HOST'].'/projects/lhr/crunchyland/');
define('FRONT_SURL','http://'.$_SERVER['HTTP_HOST'].'projects/lhr/crunchyland/');

define('IMG',SURL.'assets-frount-end/images/');
define('CSS',SURL.'assets-frount-end/css/');
define('FONTS',SURL.'assets-frount-end/font-awesome/');
define('JS',SURL.'assets-frount-end/js/');
define('VENDOR',SURL.'assets/vendor/');
define('AJAX',SURL.'assets/ajax/');
define('USER_FOLDER',SURL.'assets/user_files/');
define('CUSTOMER_FOLDER',SURL.'assets/customer_files');
define('ATTACHMENT',SURL.'attachments/');
define('SLIDER_IMAGES',SURL.'assets/slider.images/');
define('SIMPLE_SLIDER_IMAGES',SURL.'assets/slider2.images/');
define('PRODUCT_IMAGE_FOLDER',SURL.'assets/products/files/thumbnail/');
define('SIMPLE_SOCIAL_IMAGES',SURL.'assets/social.images/');
define('DEAL_IMAGE_FOLDER',SURL.'assets/deal/thumbnail/');
define('DEAL_IMAGE_FOLDER_FULL',SURL.'assets/deal/');
define('TREE',SURL.'assets/');

/* End of file constants.php */
/* Location: ./application/config/constants.php */