<?php
class mod_cms extends CI_Model {
	
	function __construct(){
		
        parent::__construct();
    }

	//Get All CMS pages.
	public function get_all_cms_pages(){
		
		$this->db->dbprefix('pages');
		$this->db->order_by('id DESC');
		$get_cms_pages = $this->db->get('pages');

		//echo $this->db->last_query();
		$row_cms['cms_pages_arr'] = $get_cms_pages->result_array();
		$row_cms['cms_pages_count'] = $get_cms_pages->num_rows;
		return $row_cms;
		
	}//end get_all_cms_pages

	//Get CMS Page Record
	public function get_cms_page($page_id){
		
		$this->db->dbprefix('pages');
		$this->db->where('id',$page_id);
		$get_cms_page = $this->db->get('pages');

		//echo $this->db->last_query();
		$row_cms['cms_page_arr'] = $get_cms_page->row_array();
		$row_cms['cms_page_count'] = $get_cms_page->num_rows;
		return $row_cms;
		
	}//end get_all_cms_pages
	
	
	
	
	//Add New Page
	public function add_new_page($data){
		
		extract($data);
		$generate_seo_url = $this->mod_common->generate_seo_url($page_title);
		$verified_seo_url = $this->mod_common->verify_seo_url($generate_seo_url,'pages','seo_url_name',0);
		
		$created_date = date('Y-m-d G:i:s');
		$ip_address = $this->input->ip_address();
		$created_by = $this->session->userdata('admin_id');
        //Uploading Slider Imaage
		if($_FILES['banner_image']['name'] != ''){

			//Create User Directory if not exist
			$slider_folder_path = '../assets/slider2.images';
	
			$file_ext           = ltrim(strtolower(strrchr($_FILES['banner_image']['name'],'.')),'.'); 			
			$file_name = 	'banner-'.date('YmdGis').'.jpg';

			$config['upload_path'] = $slider_folder_path;
			$config['allowed_types'] = 'jpg|jpeg|gif|tiff|png';
			$config['max_size']	= '6000';
			$config['overwrite'] = true;
			$config['file_name'] = $file_name;
		
			$this->load->library('upload', $config);

			if(!$this->upload->do_upload('banner_image')){
				
				$error_file_arr = array('error' => $this->upload->display_errors());
				return $error_file_arr;
				
			}else{

				$data_image_upload = array('upload_image_data' => $this->upload->data());
				
				//Resize the Uploaded Image 800 * 600
				$config_profile['image_library'] = 'gd2';
				$config_profile['source_image'] = $slider_folder_path.'/'.$file_name;
				$config_profile['create_thumb'] = TRUE;
				$config_profile['thumb_marker'] = '';
				
				$config_profile['maintain_ratio'] = TRUE;
				$config_profile['width'] = 1539;
				$config_profile['height'] = 228;
				
				$this->load->library('image_lib');
				$this->image_lib->initialize($config_profile);
				$this->image_lib->resize();
				$this->image_lib->clear();

				//Creating Thumbmail 28 * 28
				//Uploading is successful now resizing the uploaded image 
				$config_profile['image_library'] = 'gd2';
				$config_profile['source_image'] = $slider_folder_path.'/'.$file_name;
				$config_profile['new_image'] = $slider_folder_path.'/thumb/'.$file_name;
				$config_profile['create_thumb'] = TRUE;
				$config_profile['thumb_marker'] = '';
				
				$config_profile['maintain_ratio'] = TRUE;
				$config_profile['width'] = 230;
				$config_profile['height'] = 150;
				
				$this->load->library('image_lib');
				$this->image_lib->initialize($config_profile);
				$this->image_lib->resize();
				$this->image_lib->clear();
				
			}//end if(!$this->upload->do_upload('prof_image'))


		}//end if($_FILES['banner_image']['name'] != '')
		

          
		$ins_data = array(
		   'page_title' => $this->db->escape_str(trim($page_title)),
		   'page_sub_title' => $this->db->escape_str(trim($page_sub_title)),
		   'page_short_desc' => $this->db->escape_str(trim(nl2br($page_short_desc))),
		   'banner_image' => $this->db->escape_str(trim(nl2br($file_name))),
		   'page_long_desc' => $this->db->escape_str(trim($page_long_desc)),
		   'meta_title' => $this->db->escape_str(trim($meta_title)),
		   'seo_title' => $this->db->escape_str(trim($seo_title)),
		   'meta_keywords' => $this->db->escape_str(trim(nl2br($meta_keywords))),
		   'meta_description' => $this->db->escape_str(trim(nl2br($meta_description))) ,
		   'status' => $this->db->escape_str(trim($status)),
		   'seo_url_name' => $this->db->escape_str(trim($verified_seo_url)),
		   'created_by' => $this->db->escape_str(trim($created_by)),
		   'created_by_ip' => $this->db->escape_str(trim($ip_address)),
		   'created_date' => $this->db->escape_str(trim($created_date)),
		   'parentid' => $this->db->escape_str(trim($parent_page)),
		   'side_menu' => $this->db->escape_str(trim($side_menu)),
		   'sortorder' => $this->db->escape_str(trim($sortorder)),
		   'top_menu' => $this->db->escape_str(trim($top_menu))
		);

		//Insert the record into the database.
		$this->db->dbprefix('pages');
		$ins_into_db = $this->db->insert('pages', $ins_data);
		//echo $this->db->last_query();
		
		if($ins_into_db) return true;

	}//end add_new_page()
	
	//Edit Page
	public function edit_new_page($data){
		
		extract($data);
		$generate_seo_url = $this->mod_common->generate_seo_url(trim($page_title));
		$verified_seo_url = $this->mod_common->verify_seo_url($generate_seo_url,'pages','seo_url_name',$page_id);
		
		$last_modified_date = date('Y-m-d G:i:s');
		$last_modified_ip = $this->input->ip_address();
		$last_modified_by = $this->session->userdata('admin_id');
        $old_file_name = $old_banner_image;
		
		//Uploading Slider Imaage
		if($_FILES['banner_image']['name'] != ''){

			//Create User Directory if not exist
			$slider_folder_path = '../assets/slider2.images';
	
			$file_ext           = ltrim(strtolower(strrchr($_FILES['banner_image']['name'],'.')),'.'); 			
			$file_name = 	'banner-'.date('YmdGis').'.jpg';

			$config['upload_path'] = $slider_folder_path;
			$config['allowed_types'] = 'jpg|jpeg|gif|tiff|png';
			$config['max_size']	= '6000';
			$config['overwrite'] = true;
			$config['file_name'] = $file_name;
		
			$this->load->library('upload', $config);

			if(!$this->upload->do_upload('banner_image')){
				
				$error_file_arr = array('error' => $this->upload->display_errors());
				return $error_file_arr;
				
			}else{

				$data_image_upload = array('upload_image_data' => $this->upload->data());
				
				//Resize the Uploaded Image 800 * 600
				$config_profile['image_library'] = 'gd2';
				$config_profile['source_image'] = $slider_folder_path.'/'.$file_name;
				$config_profile['create_thumb'] = TRUE;
				$config_profile['thumb_marker'] = '';
				
				$config_profile['maintain_ratio'] = TRUE;
				$config_profile['width'] = 1539;
				$config_profile['height'] = 228;
				
				$this->load->library('image_lib');
				$this->image_lib->initialize($config_profile);
				$this->image_lib->resize();
				$this->image_lib->clear();

				//Creating Thumbmail 28 * 28
				//Uploading is successful now resizing the uploaded image 
				$config_profile['image_library'] = 'gd2';
				$config_profile['source_image'] = $slider_folder_path.'/'.$file_name;
				$config_profile['new_image'] = $slider_folder_path.'/thumb/'.$file_name;
				$config_profile['create_thumb'] = TRUE;
				$config_profile['thumb_marker'] = '';
				
				$config_profile['maintain_ratio'] = TRUE;
				$config_profile['width'] = 230;
				$config_profile['height'] = 150;
				
				$this->load->library('image_lib');
				$this->image_lib->initialize($config_profile);
				$this->image_lib->resize();
				$this->image_lib->clear();
				
			}//end if(!$this->upload->do_upload('prof_image'))

			//Delete Existing Image
			if(file_exists($slider_folder_path.'/'.$old_file_name)){
				
				unlink($slider_folder_path.'/'.$old_file_name);
				unlink($slider_folder_path.'/thumb/'.$old_file_name);
			}

		}else{
			$file_name = $old_file_name;	
		}//end if($_FILES['banner_image']['name'] != '')
		$upd_data = array(
		   'page_title' => $this->db->escape_str(trim($page_title)),
		   'page_sub_title' => $this->db->escape_str(trim($page_sub_title)),
		   'page_short_desc' => $this->db->escape_str(trim(nl2br($page_short_desc))),
		   'banner_image' => $this->db->escape_str(trim($file_name)),
		   'page_long_desc' => $this->db->escape_str(trim($page_long_desc)),
		   'meta_title' => $this->db->escape_str(trim($meta_title)),
		   'seo_title' => $this->db->escape_str(trim($seo_title)),
		   'meta_keywords' => $this->db->escape_str(trim(nl2br($meta_keywords))),
		   'meta_description' => $this->db->escape_str(trim(nl2br($meta_description))) ,
		   'status' => $this->db->escape_str(trim($status)),
		   'seo_url_name' => $this->db->escape_str(trim($verified_seo_url)),
		   'last_modified_by' => $this->db->escape_str(trim($last_modified_by)),
		   'last_modified_date' => $this->db->escape_str(trim($last_modified_date)),
		   'last_modified_ip' => $this->db->escape_str(trim($last_modified_ip)),
		   'parentid' => $this->db->escape_str(trim($parent_page)),
		   'side_menu' => $this->db->escape_str(trim($side_menu)),
		   'sortorder' => $this->db->escape_str(trim($sortorder)),
		   'top_menu' => $this->db->escape_str(trim($top_menu))
		);

		//Update the record into the database.
		$this->db->dbprefix('pages');
		$this->db->where('id',$page_id);
		$upd_into_db = $this->db->update('pages', $upd_data);
		//echo $this->db->last_query(); exit;
		
		if($upd_into_db) return true;

	}//end edit_new_page()

	//Delete Page
	public function delete_page($page_id){
		
		//Delete the record from the database.
		$this->db->dbprefix('pages');
		$this->db->where('id',$page_id);
		$del_into_db = $this->db->delete('pages');
		//$this->db->last_query();
		
		if($del_into_db) return true;

	}//end delete_page()

}
?>