<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class register extends CI_Controller {
	public function __construct(){
		parent::__construct();
		$this->load->model('common/mod_common');
	    $this->load->model('register/mod_register');
		$this->load->library(array('form_validation','session'));
		$this->load->helper(array('form', 'url','html','captcha'));
       
	}
	//index function for register page
	public function index(){
		$this->load->library('cart');
		$data['cart_count'] = $this->cart->total_items();
			//Common Includes
		$data['meta_title'] = DEFAULT_TITLE;
		$data['meta_keywords'] = DEFAULT_META_KEYWORDS;
		$data['meta_description'] = DEFAULT_META_DESCRIPTION;
		$data['deal_category']	=	$this->mod_common->get_all_deal_category('0');
		$data['all_menu']	=	$this->mod_common->get_all_menu();
		$data['cart_items'] = $this->cart->contents();
		$data['header_script_top'] = $this->load->view('common/script_header',$data,true);
		$data['script_footer'] = $this->load->view('common/footer',$data,true);
		$data['top_head'] = $this->load->view('common/top_head',$data,true);
		$data['script_menu'] = $this->load->view('common/menu',$data,true);
		$data['script_copy_right'] = $this->load->view('common/copy_right',$data,true);
			//Captcha Parameters
		$captcha_param = array(
								'img_path' => 'assets/captcha/',
								'img_url' => SURL.'assets/captcha/',
								'font_path' => 'assets/fonts/captcha/verdana.ttf',
								'img_height' => '40',
								'img_width' => '200'
						);
		$captcha_code = create_captcha($captcha_param);
		$data['captcha_image'] = $captcha_code['image'];
			//Adding Captcha Value in Session
		$this->session->set_userdata('captcha_code', $captcha_code['word']);
		$this->load->model('page/mod_pages');
		$get_data = $this->mod_pages->get_all_data('why-sign-up');
		$data['page_arr'] = $get_data['page_arr'];	
		$this->load->view('register/register',$data);
	} //end index()
	//fuction new user register 
	public function user_registration(){
		if($this->input->post('submit')=="guest_mail"){
		   $email_address = $this->input->post('guest_email_address'); 
			}else{
			$email_address = $this->input->post('email_address');
			}
		    $captcha_code = $this->input->post('captcha_code');
	
	
		$is_exist = $this->mod_register->check($email_address);
		if($this->session->userdata('captcha_code') != $captcha_code){
			$this->session->set_flashdata('error', '- Security Code mismatches. Please try again!');
			if($this->input->post('submit')=="guest_mail"){
				redirect(base_url().'register/login');
			}else{
			redirect(base_url().'register/register');
			}
		}
		else{
			if ($is_exist) {    
				$mailuser = $this->mod_register->add_user($this->input->post());
			
			if($mailuser==1){
				$this->session->set_flashdata('success', 'You have successfully registered with crunchyland.co.uk, please check your email to activate your account.');
				if($this->session->userdata('checkout')==true){
					$this->session->unset_userdata('checkout');
						$result = $this->mod_register->conditional_login();
							if($result!='') {
								 $sess_array = array();
									foreach($result as $row) {
									 //create the session
										$sess_array = array('email_address' => $row->email_address,
													  'user_id' => $row->id,
													  'user_first_name' => $row->first_name,
													  'user_last_name' => $row->last_name
													  );
									 //set session with value from database
										$this->session->set_userdata('userlogin', $sess_array);
									}
							}
							
				if($this->session->userdata('guest')==true){
					$this->session->unset_userdata('guest');
							 
				 	redirect(SURL.'customer/dashboard');
					
				}else {
					redirect(SURL.'check-out');
					}
					}else {
						redirect(SURL.'register/thankyou');
					}
				exit;
			}
			else{
				$this->session->set_flashdata('error', 'Not Registered. Try Agian with Different ');
				
				redirect(SURL.'register');
				exit; 
			}
		}
		     else{
				if($this->input->post('submit')=="guest_mail"){
				   $this->session->set_flashdata('error', 'Email is already registered on this web please use login form!');
				}else{
					$this->session->set_flashdata('error', 'Email you have entered already exist. Please try with another one!');
				}
				
							if($this->input->post()!='') {
								 $sess_array = array();
									
									 //create the session
										$sess_array = array(
													
													  'user_first_name' => $this->input->post('first_name'),
													  'user_last_name' => $this->input->post('last_name'),
													  'email_address' => $this->input->post('email_address'),
													  'phone' => $this->input->post('phone'),
													  'country_name' => $this->input->post('country_name'),
													  'state_name' => $this->input->post('state_name'),
													  'city_name' => $this->input->post('city_name'),
													  'postcode' => $this->input->post('postcode') 
													  );
									 //set session with value from database
										$this->session->set_userdata('userregister', $sess_array);
									
							}
		   if($this->input->post('submit')=="guest_mail"){
				redirect(base_url().'register/login');
		   }else{
			redirect(SURL.'register');
		   }
			exit;       
		}
		}
	}//end fuction user register
	//function login register user
	public function login(){
		if($this->session->userdata('userlogin')){
	    redirect(base_url().'customer/dashboard');
		}else {
			
	
		$this->load->library('cart');
		$data['cart_count'] = $this->cart->total_items();
			//Common Includes
		$data['meta_title'] = DEFAULT_TITLE;
		$data['meta_keywords'] = DEFAULT_META_KEYWORDS;
		$data['meta_description'] = DEFAULT_META_DESCRIPTION;
		$data['deal_category']	=	$this->mod_common->get_all_deal_category('0');
		$data['all_menu']	=	$this->mod_common->get_all_menu();
        $data['cart_items'] = $this->cart->contents();
		$data['header_script_top'] = $this->load->view('common/script_header',$data,true);
		$data['script_footer'] = $this->load->view('common/footer',$data,true);
		$data['top_head'] = $this->load->view('common/top_head',$data,true);
		$data['script_menu'] = $this->load->view('common/menu',$data,true);
		$data['script_copy_right'] = $this->load->view('common/copy_right',$data,true);	
				$captcha_param = array(
								'img_path' => 'assets/captcha/',
								'img_url' => SURL.'assets/captcha/',
								'font_path' => 'assets/fonts/captcha/verdana.ttf',
								'img_height' => '40',
								'img_width' => '200'
						);
		$captcha_code = create_captcha($captcha_param);
		$data['captcha_image'] = $captcha_code['image'];
		 
			//Adding Captcha Value in Session
		$this->session->set_userdata('captcha_code', $captcha_code['word']);
		$this->load->view('login/login',$data);			
	} 
	}
	//function verification of new register user
	public function verify($token){
		$result = $this->mod_register->checkmail($token);
			if($result!='') {
				$this->session->set_flashdata('success', 'Congratulations, your email is verified successfully. You can now login with your credentials');
				redirect(base_url().'register/login');
			}
			else {
				$this->session->set_flashdata('error', 'Your Process may expire please register again');
				redirect(base_url().'register/login');
			}	
	}//end function verification
	
   public function verify_email($token){
	   if($this->session->userdata('userlogin')){
		$session_data = $this->session->userdata('userlogin');
		$result = $this->mod_register->sendverifyemail($token);
		if($result ==1) {
				$this->session->set_flashdata('success', 'An email is resent to your email address. Please check your inbox for email verification');
				redirect(base_url().'customer/dashboard');
			}
			else {
				$this->session->set_flashdata('error', 'Your email Process  failed');
				redirect(base_url().'customer/dashboard');
			}	
	   }
	}
	
	//function get state list	
	public function	get_states_list($country_id){
		$get_all_states_list = $this->mod_register->get_all_states($country_id);
		$data['states_result_arr'] = $get_all_states_list['states_result'];
		$data['states_result_count'] = $get_all_states_list['states_count'];
		if($data['states_result_count'] >0){ // If State found in database .
			$response_select .= '<select  class="form-control"  id="state_name" name="state_name" required><option value="0">Select State											            </option>' ;	
				for($p=0; $p < $data['states_result_count']; $p++){
					$response_select .= "<option value=".$data['states_result_arr'][$p]['state_name'].">".$data['states_result_arr'][$p][		                    'state_name']."</option>" ;		
				}
					$response_select .= '</select>' ;		
		}
		else{
			$response_select .= ' <input id="state_name" name="state_name" type="text" class="form-control" placeholder="Enter				 		     State/Province Name "/>' ;	
		}
		echo $response_select ; 
		exit;
	}//end function get state list
	
	//function user check login
	public function check_login(){
	$result = $this->mod_register->login();
		if($result!='') {
             $sess_array = array();
             	foreach($result as $row) {
                 //create the session
              		$sess_array = array('email_address' => $row->email_address,
                                  'user_id' => $row->id,
								  'user_first_name' => $row->first_name,
								  'activation_code' => $row->activation_code,
								  'user_last_name'  => $row->last_name
								  );
                 //set session with value from database
               		$this->session->set_userdata('userlogin', $sess_array);
					if($this->session->userdata('checkout')==true){
						$this->session->unset_userdata('checkout');
				 	redirect(SURL.'check-out');
					}else {
						
						redirect(SURL.'customer/dashboard');
					}
          		}
		}
		else{
		  $this->session->set_flashdata('error', 'Invalid login: Invalid username or password.<a href="javascript:void(0)" 																	          onclick="loadforget();"> forget Password</a>');
		  redirect(base_url().'register/login');
		}
	}//end function user check login
	
	//function thankyou to new user
	public function thankyou(){
		$this->load->library('cart');
		$data['cart_count'] = $this->cart->total_items();
			//Common Includes
		$data['meta_title'] = DEFAULT_TITLE;
		$data['meta_keywords'] = DEFAULT_META_KEYWORDS;
		$data['meta_description'] = DEFAULT_META_DESCRIPTION;
		$data['deal_category']	=	$this->mod_common->get_all_deal_category('0');
		$data['all_menu']	=	$this->mod_common->get_all_menu();
        $data['cart_items'] = $this->cart->contents();
		$data['header_script_top'] = $this->load->view('common/script_header',$data,true);
		$data['script_footer'] = $this->load->view('common/footer',$data,true);
		$data['top_head'] = $this->load->view('common/top_head',$data,true);
		$data['script_menu'] = $this->load->view('common/menu',$data,true);
		$data['script_copy_right'] = $this->load->view('common/copy_right',$data,true);	
		$this->load->view('login/thankyou',$data);		
	}//end function thankyou 
	
	// function forget password
	public function forget_password(){
		  $captcha_code = $this->input->post('captcha_code');
	 
        
      	if($this->session->userdata('captcha_code') != $captcha_code){
		$this->session->set_flashdata('error', '- Security Code mismatches. Please try again!');
		redirect(base_url().'register/login');
		}
		else {
		$result = $this->mod_register->forget_password();
		if($result){
		 	$this->session->set_flashdata('success','Please check your email for password recovery.');
		 }
		 else{
		  	$this->session->set_flashdata('error','Email does not exist please enter correct email or <a href="'.SURL.'register">Register</a>');
		 }
		  }
		 	redirect(base_url().'register/login');
	}// end function forget password
	
	//function customer change forget password
	public function change_forget_password(){
		$this->load->library('cart');
		$data['cart_count'] = $this->cart->total_items();
		$data['meta_title'] = DEFAULT_TITLE;
		$data['meta_keywords'] = DEFAULT_META_KEYWORDS;
		$data['meta_description'] = DEFAULT_META_DESCRIPTION;
		$data['deal_category']	=	$this->mod_common->get_all_deal_category('0');
		$data['all_menu']	=	$this->mod_common->get_all_menu();
        $data['cart_items'] = $this->cart->contents();
		$data['header_script_top'] = $this->load->view('common/script_header',$data,true);
		$data['script_footer'] = $this->load->view('common/footer',$data,true);
		$data['top_head'] = $this->load->view('common/top_head',$data,true);
		$data['script_menu'] = $this->load->view('common/menu',$data,true);
		$data['script_copy_right'] = $this->load->view('common/copy_right',$data,true);	
		$this->load->view('login/change_password',$data);		
	}// end function customer change forget password
	
	//function customer forget password update
	public function forget_password_update(){
		$result = $this->mod_register->forget_password_update();
		if($result){
			$this->session->set_flashdata('success','Your Password Successfully Updated');
		}
		else{
			$this->session->set_flashdata('error','Your process May Expire Please try again');
		}
			redirect(base_url().'register/login');
	}//end function customer forget password update
}//end class