<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/*
|--------------------------------------------------------------------------
| File and Directory Modes
|--------------------------------------------------------------------------
|
| These prefs are used when checking and setting modes when working
| with the file system.  The defaults are fine on servers with proper
| security, but you may wish (or even need) to change the values in
| certain environments (Apache running a separate process for each
| user, PHP under CGI with Apache suEXEC, etc.).  Octal values should
| always be used to set the mode correctly.
|
*/
define('FILE_READ_MODE', 0644);
define('FILE_WRITE_MODE', 0666);
define('DIR_READ_MODE', 0755);
define('DIR_WRITE_MODE', 0777);

/*
|--------------------------------------------------------------------------
| File Stream Modes
|--------------------------------------------------------------------------
|
| These modes are used when working with fopen()/popen()
|
*/

define('FOPEN_READ',							'rb');
define('FOPEN_READ_WRITE',						'r+b');
define('FOPEN_WRITE_CREATE_DESTRUCTIVE',		'wb'); // truncates existing file data, use with care
define('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE',	'w+b'); // truncates existing file data, use with care
define('FOPEN_WRITE_CREATE',					'ab');
define('FOPEN_READ_WRITE_CREATE',				'a+b');
define('FOPEN_WRITE_CREATE_STRICT',				'xb');
define('FOPEN_READ_WRITE_CREATE_STRICT',		'x+b');

date_default_timezone_set('Asia/Karachi');

define('DEFAULT_TITLE','Best Western Hotel Lahore - The World’s Largest Hotel Chain');
define('DEFAULT_META_KEYWORDS','best western hotel lahore, best western hotel, best western, hotel lahore');
define('DEFAULT_META_DESCRIPTION','Best Western Hotel Lahore, the world’s largest Hotel chain, whose goal is to provide the best possible services to all our guests and to ensure that the stay will be an unforgettable experience.');

define('SITE_NAME','Best Western Hotel Lahore');
define('SURL','http://'.$_SERVER['HTTP_HOST'].'/hhome/');

define('IMAGE',SURL.'assets/images');
define('CSS',SURL.'assets/css');
define('FONTS',SURL.'assets/fonts');
define('JS',SURL.'assets/js');
define('ASSETS',SURL.'assets');
define('SLIDER_IMAGES',SURL.'assets/slider.images/');
define('SIMPLE_SLIDER_IMAGES',SURL.'assets/slider2.images/');
define('SIMPLE_SOCIAL_IMAGES',SURL.'assets/social.images/');
define('TESTIMONIAL_IMAGES',SURL.'assets/testimonials/');
define('GALLERY',SURL.'assets/gallery/');
define('SERVICE',SURL.'assets/serviceimages/');
/* End of file constants.php */
/* Location: ./application/config/constants.php */