<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manage_Email_Templates extends CI_Controller {

	public function __construct(){
		parent::__construct();

		$this->load->model('admin/mod_admin');
		$this->load->model('common/mod_common');
		$this->load->model('email_templates/mod_email_template');
		
		$this->load->library('BreadcrumbComponent');
		
	}

	public function index(){
		
		//Login Check
		$this->mod_admin->verify_is_admin_login();

		//Verify if Page is Accessable
		if(!in_array(12,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
		//Plugin Files Permission
		$data['PLUGIN_datagrid'] = 1;
		$data['PLUGIN_datepicker'] = 0;
		$data['PLUGIN_gcal'] = 0;
		$data['PLUGIN_form_validation'] = 1;
		$data['PLUGIN_gallery'] = 0;
		$data['PLUGIN_ckeditor'] = 0;
		$data['PLUGIN_floatchart'] = 0;
		
		//Common Includes
		$data['meta_title'] = DEFAULT_TITLE;
		$data['meta_keywords'] = DEFAULT_META_KEYWORDS;
		$data['meta_description'] = DEFAULT_META_DESCRIPTION;
		
		$fetch_nav_panel = $this->mod_common->fetch_admin_nav_panel();
		$data['nav_panel_arr'] = $fetch_nav_panel;
		
		//Permissions
		$data['ALLOW_user_edit'] =   (in_array(55,$this->session->userdata('permissions_arr'))) ? 1 : 0;
		$data['ALLOW_user_delete'] =   (in_array(56,$this->session->userdata('permissions_arr'))) ? 1 : 0;
		$data['ALLOW_pages_add'] =   (in_array(53,$this->session->userdata('permissions_arr'))) ? 1 : 0;
		

		//Bread crum
		$this->breadcrumbcomponent->add('Dashboard', base_url().'dashboard/dashboard');
		$this->breadcrumbcomponent->add('Manage Email Templates', base_url().'email-templates/manage-email-templates');
		$data['breadcrum_data'] = $this->breadcrumbcomponent->output();
		
		$data['INC_header_script_top'] = $this->load->view('common/script_header',$data,true);
		$data['INC_header_script_footer'] = $this->load->view('common/script_footer',$data,true);
		$data['INC_top_header'] = $this->load->view('common/top_header','',true);
		$data['INC_left_nav_panel'] = $this->load->view('common/left_nav_panel',$data,true);
		$data['INC_footer'] = $this->load->view('common/footer','',true);
		$data['INC_breadcrum'] = $this->load->view('common/breadcrum','',true);
		
		$email_templates_arr = $this->mod_email_template->get_email_templates();
		$data['email_templates_arr'] = $email_templates_arr['email_templates_result'];
		$data['email_templates_count'] = $email_templates_arr['email_templates_count'];
		
		
        
		$this->load->view('email_templates/manage_email_template',$data);
			
	}//end index()
	
	//Add email_template
	public function add_email_template(){
	
		//Login Check
		$this->mod_admin->verify_is_admin_login();

		//Verify if Page is Accessable
		if(!in_array(8,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
		
		//Plugin Files Permission
		$data['PLUGIN_datagrid'] = 0;
		$data['PLUGIN_datepicker'] = 0;
		$data['PLUGIN_gcal'] = 0;
		$data['PLUGIN_form_validation'] = 1;
		$data['PLUGIN_gallery'] = 0;
		$data['PLUGIN_ckeditor'] = 1;
		$data['PLUGIN_floatchart'] = 0;
		
		//Common Includes
		$data['meta_title'] = DEFAULT_TITLE;
		$data['meta_keywords'] = DEFAULT_META_KEYWORDS;
		$data['meta_description'] = DEFAULT_META_DESCRIPTION;

		$fetch_nav_panel = $this->mod_common->fetch_admin_nav_panel();
		$data['nav_panel_arr'] = $fetch_nav_panel;

		//Bread crum
		$this->breadcrumbcomponent->add('Dashboard', base_url().'dashboard/dashboard');
		$this->breadcrumbcomponent->add('Manage Templates', base_url().'email_templates/manage-email-templates');
		$this->breadcrumbcomponent->add('Add New Template', base_url().'email-templates/manage-email-templates/add_email_template');
		$data['breadcrum_data'] = $this->breadcrumbcomponent->output();
		
		$data['INC_header_script_top'] = $this->load->view('common/script_header',$data,true);
		$data['INC_header_script_footer'] = $this->load->view('common/script_footer',$data,true);
		$data['INC_top_header'] = $this->load->view('common/top_header','',true);
		$data['INC_left_nav_panel'] = $this->load->view('common/left_nav_panel',$data,true);
		$data['INC_footer'] = $this->load->view('common/footer','',true);
		$data['INC_breadcrum'] = $this->load->view('common/breadcrum','',true);
		
		$this->load->view('email_templates/add_email_template',$data);
		
	}//add_email_template

	public function add_email_template_process(){
		
		//If Post is not SET
		if(!$this->input->post() && !$this->input->post('add_email_template_sbt')) redirect(base_url());
		
		//Login Check
		$this->mod_admin->verify_is_admin_login();

		//Verify if Page is Accessable
		if(!in_array(8,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
		$err_msg = '';

		if(trim($this->input->post('title')) == ''){
			
			$err_msg.= '- Title cannot be empty.<br>';
			
		}//end if(trim($this->input->post('page_title')) == '')
		
		if(trim($this->input->post('email_subject')) == ''){
			
			$err_msg.= '- Email Subject cannot be empty.<br>';
			
		}//end if(trim($this->input->post('page_title')) == '')


		if(trim($this->input->post('email_body')) == ''){
			
			$err_msg.= '- Email Body cannot be empty.<br>';
			
		}//end if(trim($this->input->post('page_title')) == '')
		
		
		if($err_msg !=''){

			$this->session->set_flashdata('err_message', $err_msg);
			redirect(base_url().'email_templates/manage_email_templates/add_email_template');
			
		}//end if($err_msg !='')

		
			//Add New Email Template	
			$add_email_template = $this->mod_email_template->add_email_template($this->input->post());
			
			if($add_email_template && $add_email_template['error'] == ''){
				
				//Unset POST values from session
				$this->session->unset_userdata('add-user-data');
				
				$this->session->set_flashdata('ok_message', '- New Email Template added successfully.');
				redirect(base_url().'email_templates/manage_email_templates/add_email_template');
				
			}else{
				
				if($add_email_template['error'] != ''){
					$this->session->set_flashdata('err_message', '- '.strip_tags($add_new_user['error']));
					redirect(base_url().'email_templates/manage_email_templates/add_email_template');
					
				}else{
					$this->session->set_flashdata('err_message', '- New Email Template cannot be added. Something went wrong, please try again.');
					redirect(base_url().'email_templates/manage_email_templates/add_email_template');
					
				}//end if($add_new_user['error'] != '')
				
			}//end if($upd_admin_profile)

	}//end add_email_template_process
	


	
	public function edit_email_template($id){
		
		//Login Check
		$this->mod_admin->verify_is_admin_login();

		//Verify if Page is Accessable
		if(!in_array(12,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
		//Plugin Files Permission
		$data['PLUGIN_datagrid'] = 0;
		$data['PLUGIN_datepicker'] = 0;
		$data['PLUGIN_gcal'] = 0;
		$data['PLUGIN_form_validation'] = 1;
		$data['PLUGIN_gallery'] = 0;
		$data['PLUGIN_ckeditor'] = 1;
		$data['PLUGIN_floatchart'] = 0;
		
		//Common Includes
		$data['meta_title'] = DEFAULT_TITLE;
		$data['meta_keywords'] = DEFAULT_META_KEYWORDS;
		$data['meta_description'] = DEFAULT_META_DESCRIPTION;
		
		$fetch_nav_panel = $this->mod_common->fetch_admin_nav_panel();
		$data['nav_panel_arr'] = $fetch_nav_panel;

		//Bread crum
		$this->breadcrumbcomponent->add('Dashboard', base_url().'dashboard/dashboard');
		$this->breadcrumbcomponent->add('Manage Templates', base_url().'email_templates/manage-email-templates');
		$this->breadcrumbcomponent->add('Edit Email Template', base_url().'email-templates/manage-email-templates/edit_email_template');
		$data['breadcrum_data'] = $this->breadcrumbcomponent->output();
		
		$data['INC_header_script_top'] = $this->load->view('common/script_header',$data,true);
		$data['INC_header_script_footer'] = $this->load->view('common/script_footer',$data,true);
		$data['INC_top_header'] = $this->load->view('common/top_header','',true);
		$data['INC_left_nav_panel'] = $this->load->view('common/left_nav_panel',$data,true);
		$data['INC_footer'] = $this->load->view('common/footer','',true);
		$data['INC_breadcrum'] = $this->load->view('common/breadcrum','',true);
		
		$edit_email_template_arr = $this->mod_email_template->edit_email_template($id);
		
		$data['edit_email_template_data'] = $edit_email_template_arr;
		
		/*print_r($edit_site_preferences_arr);
		exit;*/
	
		$this->load->view('email_templates/edit_email_template',$data);
		
	}//edit_email_template
	
	
	public function edit_email_template_process(){
		
		//If Post is not SET
		if(!$this->input->post() && !$this->input->post('edit_email_template_sbt')) redirect(base_url());
		
		//Login Check
		$this->mod_admin->verify_is_admin_login();

		//Verify if Page is Accessable
		if(!in_array(12,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
				
		//Updating Email Template
		$upd_email_template = $this->mod_email_template->update_email_template_process($this->input->post());
		
		if($upd_email_template && $upd_email_template['error'] == ''){
			
			$this->session->set_flashdata('ok_message', '- Email Template  updated successfully.');
			redirect(base_url().'email_templates/manage_email_templates');
			
		}else{

			if($upd_email_template['error'] != ''){
				
				$this->session->set_flashdata('err_message', '- '.strip_tags($upd_admin['error']));
				redirect(base_url().'email_templates/manage_email_templates');
				
			}else{
				
				$this->session->set_flashdata('err_message', '-  Email Template cannot be updated. Something went wrong, please try again.');
				redirect(base_url().'email_templates/manage_email_templates');

			}
			
		}//end if

	}//end edit email_template_process
	
	
	public function delete_email_template($id){
		
		//Login Check
		$this->mod_admin->verify_is_admin_login();

		//Verify if Page is Accessable
		if(!in_array(10,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if

	
		$del_email_template= $this->mod_email_template->delete_email_template($id);
		
		if($del_email_template){
			
			$this->session->set_flashdata('ok_message', '- Email Template deleted successfully.');
			redirect(base_url().'email_templates/manage_email_templates');
			
		}else{
			$this->session->set_flashdata('err_message', '- Email Template cannot be deleted. Something went wrong, please try again.');
			redirect(base_url().'email_templates/manage_email_templates');
			
		}//end if

	}//end delete_email_template
	

}//end Dashboard 
